//********************************************************************
//  BrickWall.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.24 (5E, p. 288)
//********************************************************************

import javax.swing.JApplet;
import java.awt.*;

public class BrickWall extends JApplet
{
   private final int NUM_ROWS = 10;
   private final int NUM_COLS = 12;
   private final int START_X = 0;
   private final int START_Y = 0;
   private final int BRICK_WIDTH = 32;
   private final int BRICK_HEIGHT = 16;
   private final int GAP = 4;

   //-----------------------------------------------------------------
   //  Paints a brick wall.
   //-----------------------------------------------------------------
   public void paint(Graphics page)
   {
      int x = START_X, y = START_Y;

      setBackground (Color.darkGray);
      page.setColor (Color.red);

      for (int row=1; row <= NUM_ROWS; row++)
      {

         for (int col=1; col <= NUM_COLS; col++)
         {
            page.fillRect (x, y, BRICK_WIDTH, BRICK_HEIGHT);
            x += BRICK_WIDTH + GAP;
         }

         if (row%2 == 0)
            x = START_X;
         else
            x = START_X - BRICK_WIDTH/2 - GAP/2;

         y += BRICK_HEIGHT + GAP;

      }
   }
}
